<?php

/**
 * This controller shows an area that's only visible for logged in users (because of Auth::checkAuthentication(); in line 16)
 */
class GalleryController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();

        // this entire controller should only be visible/usable by logged in users, so we put authentication-check here
        Auth::checkAuthenticationJson();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    public function index()
    {
        
        GalleryModel::getImages();
    }
    
     public function subimage($image_id = 0)
    {
        
        GalleryModel::getSubImages($image_id);
    }
    
    public function images() {
        
        if (isset($_GET['image_url'])) {
    $image_url = $_GET['image_url'];
    header('Content-Type: image/jpeg');
    readfile(urldecode($image_url));
} else {
    http_response_code(400); // Bad Request
}
    }
}
